(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     24067,        788]*)
(*NotebookOutlinePosition[     24970,        818]*)
(*  CellTagsIndexPosition[     24926,        814]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Convert\nOne Differential Equation\nto a System\nof Differential Equations"],
   "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Though we study single higher order differential equations, the ",
  StyleBox[
  "natural environment in which they should be studied is that of vector \
(even matrix) systems of first order differential equations",
    FontVariations->{"Underline"->True}],
  ". This notebook implements the standard procedure for converting a single \
higher order equation into a first order system of differential equations."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The Theory"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Given a differential equation of the form\n\t",
  Cell[BoxData[
      \(TraditionalForm\`D[y[x], {x, n}] == 
        f[x, y[x], \(y'\)[x],  ... \ \ , D[y[x], {x, n - 1}]]\)]],
  ",\nwe select n auxilliary functions {",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            SubscriptBox[
              StyleBox["u",
                FontSlant->"Italic"], "0"],
            "TraditionalForm"], "[", "x", "]"}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            SubscriptBox[
              StyleBox["u",
                FontSlant->"Italic"], "1"],
            "TraditionalForm"], "[", "x", "]"}], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            SubscriptBox[
              StyleBox["u",
                FontSlant->"Italic"], \(n - 1\)],
            "TraditionalForm"], "[", "x", "]"}], TraditionalForm]]],
  "} by setting:\n\t\t        ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[
                SubscriptBox[
                  StyleBox["u",
                    FontSlant->"Italic"], "0"],
                "TraditionalForm"], "[", "x", "]"}], "=", \(y\ [x]\)}], ","}],
         TraditionalForm]]],
  StyleBox[" \n\t\t\t   \t", "Input",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[
                SubscriptBox[
                  StyleBox["u",
                    FontSlant->"Italic"], "1"],
                "TraditionalForm"], "[", "x", "]"}], "=", \(\(y'\)\ [x]\)}], 
          " ", ",", "\[IndentingNewLine]", "...", "  ", ","}], 
        TraditionalForm]]],
  StyleBox[" \t\t\t\n\t\t\t\t", "Input",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"u", 
            RowBox[{
              FormBox[\(\_\(n - 1\)\),
                "TraditionalForm"], "[", "x", "]"}]}], 
          "=", \(\(D[y[x], {x, n - 1}]\)\(.\)\)}], TraditionalForm]]],
  "\nThen differentiate these equations to obtain:\n",
  StyleBox["\t\t\t    ",
    FontSize->10],
  StyleBox[Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(u\_0\),
                "TraditionalForm"], "'"}], " ", "[", "x", "]"}], 
          "=", \(u\_1\)}], TraditionalForm]], "Input",
    FontWeight->"Plain"], "Input"],
  StyleBox["[x],", "Input",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain"],
  StyleBox[" \n\t\t\t  ",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(u\_1\),
                "TraditionalForm"], "'"}], " ", "[", "x", "]"}], 
          "=", \(u\_2\)}], TraditionalForm]], "Input",
    FontWeight->"Plain"], "Input"],
  StyleBox["[x],", "Input",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain"],
  StyleBox["\n\t\t\t\t",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox["...,", "Input",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain"],
  StyleBox["\n\t\t\t  ",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(\(u\_\(n - 2\)'\)\(\ \)\),
              "TraditionalForm"], "[", "x", "]"}], "=", \(u\_\(n - 1\)\)}], 
        TraditionalForm]], "Input",
    FontWeight->"Plain"], "Input"],
  StyleBox["[x],", "Input",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain"],
  StyleBox["\n\t\t\t  ",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{
                        FormBox[\(\(u\_\(n - 1\)'\)\(\ \)\),
                          "TraditionalForm"], "[", "x", "]"}], 
                      "=", \(\(f\)\([\)\(x\ , u\_0\)\)}],
                    "TraditionalForm"], "[", "x", "]"}], " ", ",", \(u\_1\)}],
              
              "TraditionalForm"], "[", "x", "]"}], " ", ",", "...", " ", ",", 
          " ", \(u\_\(n - 2\)\)}], TraditionalForm]], "Input",
    FontWeight->"Plain"], "Input"],
  StyleBox["[x]]", "Input",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain"],
  StyleBox["\t",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "\t\t\nThis is the first order system we want. Notice that the reduction \
from a single equation to a system works even if the original equation is \
nonlinear."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A (general) Example"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Consider the general third order linear constant coefficients differential \
equation \n",
  StyleBox["L[x, y]==f[x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", where:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{\(Clear[x, y, a, b, c, L, f, u, i]\), "\n", 
    RowBox[{\(L[x_, y_]\), ":=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}], "+", 
        RowBox[{"a", " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"b", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(c\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[TextData[
"As we have done before, substitute for the the derivatives in the \
operator:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"algebraic", "=", 
      RowBox[{\(L[x, y]\), "/.", 
        RowBox[{"{", 
          RowBox[{\(y[x] \[Rule] \(Subscript[u, 0]\)[x]\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((p_)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Rule]", \(\(Subscript[u, p]\)[x]\)}]}], "}"}]}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c\ u\_0[x] + b\ u\_1[x] + a\ u\_2[x] + u\_3[x]\)], "Output"]
}, Open  ]],

Cell[TextData[
"From this expression we can determine the order of the equation. (The \
alternative is to have you specify the order when you state the problem.)"], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(theOrder = 
      Max[Select[
          List @@ algebraic /. {\(Subscript[u, p_]\)[x] \[Rule] p, 
              c_. \ \(Subscript[u, p_]\)[x] \[Rule] p}, NumberQ]]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    \(3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lastEqnRHS = \((\(Subscript[u, theOrder]\)[x] /. 
            Solve[algebraic == f[x], \(Subscript[u, theOrder]\)[
                x]])\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(f[x] - c\ u\_0[x] - b\ u\_1[x] - a\ u\_2[x]\)], "Output"]
}, Open  ]],

Cell[TextData[
"Here, then, is the desired first order system: (formatted nicely)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(tab = 
      Table[\(Subscript[u, i]'\)[x] == \(Subscript[u, i + 1]\)[x], {i, 0, 
          order - 2}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox[\(u\_0\), "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(u\_1[x]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(u\_1\), "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(u\_2[x]\)}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Leq", "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox[\(Subscript[u, theOrder - 1]\), "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "==", 
        "lastEqnRHS"}]}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox[\(u\_2\), "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], 
      "\[Equal]", \(f[x] - c\ u\_0[x] - b\ u\_1[x] - a\ u\_2[x]\)}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((sys = Append[tab, Leq])\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_0\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(u\_1[x]\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_1\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(u\_2[x]\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_2\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x] - c\ u\_0[x] - b\ u\_1[x] - a\ u\_2[x]\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 0]][ x], 
          Subscript[ u, 1][ x]], 
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 1]][ x], 
          Subscript[ u, 2][ x]], 
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 2]][ x], 
          Plus[ 
            f[ x], 
            Times[ -1, c, 
              Subscript[ u, 0][ x]], 
            Times[ -1, b, 
              Subscript[ u, 1][ x]], 
            Times[ -1, a, 
              Subscript[ u, 2][ x]]]]}]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Automate the process"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "We merely collect the above steps into a function which has all of the \
parameters needed to completely describe the necessary steps: Take special \
note that ",
  StyleBox["dep",
    FontWeight->"Bold"],
  " should be the name of the dependent variable, not its value! The ",
  StyleBox["?AtomQ",
    FontWeight->"Bold"],
  " modifier on ",
  StyleBox["dep_",
    FontWeight->"Bold"],
  " assures that the function will not execute unless this is so."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    RowBox[{\(Clear[EqnToSys, operator, rhs, dep, indep, lastEqnRHS, 
        theOrder]\), "\n"}], "\[IndentingNewLine]", 
    RowBox[{\(EqnToSys[operator_, rhs_, dep_?AtomQ, indep_]\), ":=", 
      RowBox[{"Block", "[", 
        RowBox[{\({algebraic, theOrder, lastEqnRHS, i}\), ",", 
          RowBox[{
            RowBox[{"algebraic", "=", 
              RowBox[{"operator", "/.", 
                RowBox[{"{", 
                  
                  RowBox[{\(dep[indep] \[Rule] \(Subscript[u, 0]\)[indep]\), 
                    ",", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox["dep", 
                          TagBox[\((p_)\),
                            Derivative],
                          MultilineFunction->None], "[", "indep", "]"}], 
                      "\[Rule]", \(\(Subscript[u, p]\)[indep]\)}]}], 
                  "}"}]}]}], 
            ";", \(theOrder = 
              Max[Select[
                  List @@ algebraic /. {\(Subscript[u, p_]\)[x] \[Rule] p, 
                      c_. \ \(Subscript[u, p_]\)[x] \[Rule] p}, NumberQ]]\), 
            ";", \(lastEqnRHS = \((\(Subscript[u, theOrder]\)[indep] /. 
                    Solve[algebraic == rhs, \(Subscript[u, theOrder]\)[
                        indep]])\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)\
, ";", 
            RowBox[{"Append", "[", 
              RowBox[{
                RowBox[{"Table", "[", 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        SuperscriptBox[\(Subscript[u, i]\), "\[Prime]",
                          MultilineFunction->None], "[", "indep", "]"}], 
                      "==", \(\(Subscript[u, i + 1]\)[indep]\)}], 
                    ",", \({i, 0, theOrder - 2}\)}], "]"}], ",", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      
                      SuperscriptBox[\(Subscript[u, theOrder - 1]\), 
                        "\[Prime]",
                        MultilineFunction->None], "[", "indep", "]"}], "==", 
                    "lastEqnRHS"}], "}"}]}], "]"}]}]}], "]"}]}]}], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Apply the definition to our Sample"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y, a, b, c, L, f, u, i, p, order]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}], "+", 
        RowBox[{"a", " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"b", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(c\ y[x]\)}]}]}], "Input"],

Cell[BoxData[
    RowBox[{\(c\ y[x]\), "+", 
      RowBox[{"b", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"a", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["y", 
          TagBox[\((3)\),
            Derivative],
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(EqnToSys[L[x, y], f[x], y, x] // TableForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_0\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(u\_1[x]\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_1\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(u\_2[x]\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_2\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x] - c\ u\_0[x] - b\ u\_1[x] - a\ u\_2[x]\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 0]][ x], 
          Subscript[ u, 1][ x]], 
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 1]][ x], 
          Subscript[ u, 2][ x]], {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 2]][ x], 
          Plus[ 
            f[ x], 
            Times[ -1, c, 
              Subscript[ u, 0][ x]], 
            Times[ -1, b, 
              Subscript[ u, 1][ x]], 
            Times[ -1, a, 
              Subscript[ u, 2][ x]]]]}}]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples (Try these) Given: L[x,y],F,y,x", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y''\)[x] + \(s\^2\) y[x] == 0\)], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EqnToSys[\(y''\)[x] + \(s\^2\) y[x], 0, y, x] // TableForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_0\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(u\_1[x]\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_1\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(\(-s\^2\)\ u\_0[x]\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 0]][ x], 
          Subscript[ u, 1][ x]], {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 1]][ x], 
          Times[ -1, 
            Power[ s, 2], 
            Subscript[ u, 0][ x]]]}}]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y''\)[x] - \(s\^2\) y[x] == 0\)], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EqnToSys[\(y''\)[x] - \(s\^2\) y[x], 0, y, x] // TableForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_0\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(u\_1[x]\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_1\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(s\^2\ u\_0[x]\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 0]][ x], 
          Subscript[ u, 1][ x]], {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 1]][ x], 
          Times[ 
            Power[ s, 2], 
            Subscript[ u, 0][ x]]]}}]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}], "-", 
        RowBox[{"F", "[", 
          RowBox[{"x", ",", \(y[x]\), ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], "==", 
      "0"}]], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"EqnToSys", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}], "-", 
            RowBox[{"F", "[", 
              RowBox[{"x", ",", \(y[x]\), ",", 
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}], ",", 
                RowBox[{
                  SuperscriptBox["y", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}]}], "]"}]}], ",",
           "0", ",", "y", ",", "x"}], "]"}], "//", "TableForm"}]], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_0\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(u\_1[x]\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_1\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(u\_2[x]\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox[\(u\_2\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(F[x, u\_0[x], u\_1[x], u\_2[x]]\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 0]][ x], 
          Subscript[ u, 1][ x]], 
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 1]][ x], 
          Subscript[ u, 2][ x]], {
        Equal[ 
          Derivative[ 1][ 
            Subscript[ u, 2]][ x], 
          F[ x, 
            Subscript[ u, 0][ x], 
            Subscript[ u, 1][ x], 
            Subscript[ u, 2][ x]]]}}]]], "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{577, 615},
WindowMargins->{{20, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 157, 4, 155, "Subtitle",
  Evaluatable->False],
Cell[1936, 59, 492, 10, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2453, 73, 88, 2, 56, "Section",
  Evaluatable->False],
Cell[2544, 77, 5003, 163, 265, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7584, 245, 97, 2, 36, "Section",
  Evaluatable->False],
Cell[7684, 249, 263, 9, 50, "Text",
  Evaluatable->False],
Cell[7950, 260, 650, 17, 45, "Input"],
Cell[8603, 279, 153, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8781, 287, 481, 12, 66, "Input"],
Cell[9265, 301, 80, 1, 27, "Output"]
}, Open  ]],
Cell[9360, 305, 224, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9609, 314, 225, 6, 91, "Input"],
Cell[9837, 322, 35, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9909, 328, 239, 4, 59, "Input"],
Cell[10151, 334, 77, 1, 27, "Output"]
}, Open  ]],
Cell[10243, 338, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10409, 345, 136, 3, 43, "Input"],
Cell[10548, 350, 432, 12, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11017, 367, 237, 6, 27, "Input"],
Cell[11257, 375, 220, 5, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11514, 385, 74, 1, 27, "Input"],
Cell[11591, 388, 1422, 44, 57, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[13062, 438, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[13163, 442, 533, 15, 86, "Text",
  Evaluatable->False],
Cell[13699, 459, 2221, 47, 346, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[15957, 511, 112, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16094, 517, 632, 16, 45, "Input"],
Cell[16729, 535, 507, 14, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17273, 554, 102, 2, 27, "Input"],
Cell[17378, 558, 1424, 44, 69, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[18851, 608, 108, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18984, 614, 72, 1, 43, "Subsubsection"],

Cell[CellGroupData[{
Cell[19081, 619, 118, 2, 31, "Input"],
Cell[19202, 623, 925, 29, 43, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[20176, 658, 72, 1, 29, "Subsubsection"],

Cell[CellGroupData[{
Cell[20273, 663, 118, 2, 31, "Input"],
Cell[20394, 667, 916, 29, 55, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[21359, 702, 589, 16, 29, "Subsubsection"],

Cell[CellGroupData[{
Cell[21973, 722, 737, 18, 48, "Input"],
Cell[22713, 742, 1302, 40, 69, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

)

